package gov.va.vamf.scheduling.direct.domain;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.veteranappointment.domain.Namespace;
import com.fasterxml.jackson.annotation.JsonInclude;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "direct-scheduling-clinic", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
public class CdwClinic extends DomainTransferObject {

    @XmlElement
    private String siteCode;
    @XmlElement
    private String clinicId;
    @XmlElement
    private String clinicName;
    @XmlElement(nillable = true)
    @JsonInclude(JsonInclude.Include.ALWAYS)
    private String clinicFriendlyLocationName;
    @XmlElement
    private String primaryStopCode;
    @XmlElement
    private String secondaryStopCode;
    @XmlElement
    private String directSchedulingFlag;
    @XmlElement
    private String displayToPatientFlag;
    @XmlElement
    private String institutionName;
    @XmlElement
    private String institutionCode;

    public CdwClinic() {
    }

    public String getSiteCode() {
        return siteCode;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getClinicId() {
        return clinicId;
    }

    public void setClinicId(String clinicId) {
        this.clinicId = clinicId;
    }

    public String getClinicName() {
        return clinicName;
    }

    public void setClinicName(String clinicName) {
        this.clinicName = clinicName;
    }

    public String getClinicFriendlyLocationName() {
        return clinicFriendlyLocationName;
    }

    public void setClinicFriendlyLocationName(String clinicFriendlyLocationName) {
        this.clinicFriendlyLocationName = clinicFriendlyLocationName;
    }

    public String getPrimaryStopCode() {
        return primaryStopCode;
    }

    public void setPrimaryStopCode(String primaryStopCode) {
        this.primaryStopCode = primaryStopCode;
    }

    public String getSecondaryStopCode() {
        return secondaryStopCode;
    }

    public void setSecondaryStopCode(String secondaryStopCode) {
        this.secondaryStopCode = secondaryStopCode;
    }

    public String getDirectSchedulingFlag() {
        return directSchedulingFlag;
    }

    public void setDirectSchedulingFlag(String directSchedulingFlag) {
        this.directSchedulingFlag = directSchedulingFlag;
    }

    public String getDisplayToPatientFlag() {
        return displayToPatientFlag;
    }

    public void setDisplayToPatientFlag(String displayToPatientFlag) {
        this.displayToPatientFlag = displayToPatientFlag;
    }

    public String getInstitutionName() {
        return institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public String getInstitutionCode() {
        return institutionCode;
    }

    public void setInstitutionCode(String institutionCode) {
        this.institutionCode = institutionCode;
    }
}
